/*
 * $COPYRIGHT$
 * $Id: XMLAnalyzer.java,v 1.19 2001/10/31 21:38:58 crow Exp $
 *
 *  Date        Author            Changes
 * May 28 2001  Szabo Csaba       Created
 */

package org.media.datastore.sepengine.util;

import java.util.Vector;
import java.util.Enumeration;
import java.util.StringTokenizer;

import java.io.InputStream;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;
import org.xml.sax.*;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.ext.LexicalHandler; 

import org.media.datastore.sepengine.LogManager;
import org.media.datastore.sepengine.SepInterpreter;
 
/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.19 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 * @see java.io.InputStream
 * @see org.media.datastore.sepengine.RDBInfo
 * @see org.xml.sax.HandlerBase
 */
        
public class XMLAnalyzer extends DefaultHandler implements LexicalHandler {
    
    private String       tree_name;
    private StringBuffer parents;
    private boolean      updateDTD;
    private boolean      validate;
    
    
    public XMLAnalyzer( InputStream src, String subtree, String dtdName, boolean valid ) 
	throws Exception {
	
	try {
	    DTDRegister.getReference().loadDTD( subtree, dtdName );
	}   
	catch ( Exception e ) {
	    throw new Exception ( e.getMessage() );
	}
	
	parents    = new StringBuffer();
        updateDTD  = false;
        validate   = valid;
	tree_name  = subtree;
	
	SAXParserFactory factory = SAXParserFactory.newInstance();
        if ( validate ) factory.setValidating( true );
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse( src, this );
        } 
        catch ( Exception e ) {
            throw new Exception ( "\n" + e.getMessage() + "\n" + LogManager.getReference().getMessage("xml.parse_exception") );
        }
	        
        if ( !validate && updateDTD ) {
	    try {
		DTDRegister.getReference().saveDTD( subtree, dtdName );		
		LogManager.getReference().message("info", "dtd.file_update", dtdName);
	    }
	    catch ( Exception e ) {
		throw new Exception ( e.getMessage() );
	    }
	}
    }
    
    
    public void startDocument() throws SAXException {
        parents = new StringBuffer();
    }

        
    public void startElement( String uri, String name, String qname, Attributes attrs ) throws SAXException {
        String    pName = getParentName();
        Vector elements = DTDRegister.getReference().getDTDElements( tree_name );
	
	if ( elements == null ) throw new SAXException( LogManager.getReference().getMessage("dtd.read_error") );
	
        parents.append( ", " + qname );
        
        if ( !DTDRegister.getReference().inDTD( tree_name, qname ) ) {
            if ( validate ) throw new SAXException( LogManager.getReference().getMessage("xml_invalid") );

            try {
                elements.addElement( new MyElement( "<!ELEMENT " + qname + " {SPECIAL} >" ) );
    	    }
	    catch ( Exception e ) {
                LogManager.getReference().message("error", "add_new_dtd_element_failed", qname );
		throw new SAXException( LogManager.getReference().getMessage("add_new_dtd_element_failed") + qname );
            }
        }    
        
	try {
	    for ( Enumeration e = elements.elements(); e.hasMoreElements(); ) {
        	MyElement _elem = ( MyElement )e.nextElement();
                if ( _elem.getType().equals( "ELEMENT" ) && _elem.getName().equals( pName ) ) {
		    if ( _elem.addElements( qname + "+" ) ) updateDTD = true;
                    break;
                }
            }
	}
        catch ( Exception e ) {
            LogManager.getReference().message("error", "add_new_dtd_element_failed", qname );
	    throw new SAXException( LogManager.getReference().getMessage("add_new_dtd_element_failed") + qname );
        }
        
        if ( attrs != null ) {
            for ( int i = 0; i < attrs.getLength(); i++ ) {
                boolean foundAttr = false;

                for ( Enumeration e = elements.elements(); e.hasMoreElements(); ) {
                    MyElement elem = ( MyElement )e.nextElement();
                    if ( elem.getType().equals( "ATTLIST" ) && elem.getName().equals( qname ) ) {
                        int state = elem.addAttr( attrs.getQName(i) , validate );

                        if ( state == -1 )
			    throw new SAXException( LogManager.getReference().getMessage("add_new_dtd_element_failed") + 
			                            qname + "." + attrs.getQName(i) );
                        foundAttr = true;
                        if ( !updateDTD ) updateDTD = state == 1;
                        break;
                    }
                }
                
                if ( !foundAttr ) {
                    updateDTD = true;
		    if ( validate ) throw new SAXException( LogManager.getReference().getMessage("xml_invalid") );

                    try {
                        elements.addElement( new MyElement( "<!ATTLIST " + qname + "\n\t" + attrs.getQName(i) + " CDATA #IMPLIED>" ) );
                    }
                    catch ( Exception e ) {
                        LogManager.getReference().message("error", "add_new_dtd_element_failed", qname );
    			throw new SAXException( LogManager.getReference().getMessage("add_new_dtd_element_failed") + 
			                        qname + "." + attrs.getQName(i) );
                    }
                }
            }
        }
    }
    

    public void endElement( String uri, String name, String qname ) throws SAXException {
        String pName = parents.toString().trim();
        int      poz = pName.lastIndexOf( "," );        

        if ( poz != -1 ) pName = pName.substring( poz + 1 ).trim();
        if ( poz < 0 ) poz = 0;
        if ( !qname.equals( pName ) )
            throw new SAXException( LogManager.getReference().getMessage("end_element_missing") + " '" + qname + "'" );
        parents.delete( poz, parents.length() );
    }
    

    public void characters( char ch[], int start, int length ) throws SAXException {
        String   str = new String( ch, start, length );
        String pName = getParentName();
        Vector elements = DTDRegister.getReference().getDTDElements( tree_name );

	if ( elements == null ) throw new SAXException( LogManager.getReference().getMessage("dtd.read_error") );

        if ( str.trim().length() > 0 ) {
            for ( Enumeration e = elements.elements(); e.hasMoreElements() ; ) {
                MyElement _elem = ( MyElement )e.nextElement();
        
                if ( _elem.getType().equals("ELEMENT") && _elem.getName().equals( pName ) ) {
                    if ( _elem.getValue().indexOf("#PCDATA") == -1 ) {
    			if ( validate ) throw new SAXException( LogManager.getReference().getMessage("xml_invalid") );
                        _elem.addPCData();
                    }
                }
            }
        }
    }
    

    public void ignorableWhitespace( char ch[], int start, int length ) throws SAXException {
        characters( ch, start, length );
    }


    public void comment( char ch[], int start, int length ) throws SAXException {
    }
                                 

    public void startCDATA() throws SAXException {
    }
                                                         

    public void endCDATA() throws SAXException {
    }


    public void startDTD( String name, String pID, String sId ) throws SAXException {
    }
                                                         

    public void endDTD() throws SAXException {
    }
                                                                         

    public void startEntity( String name ) throws SAXException {
    }

                                                                                 
    public void endEntity( String name ) throws SAXException {
    }    


    private String getParentName( ) {
        String pName = parents.toString().trim();
        int     _poz = pName.lastIndexOf( "," );
        if ( _poz != -1 ) pName = pName.substring( _poz + 1 ).trim();
        return pName;    
    }
}
