/*
 * $COPYRIGHT$
 * $Id: XmlRpcServer.java,v 1.8 2001/12/18 17:20:13 atech Exp $
 *
 * Date         Author          Changes
 * May 28 2001  Antal Attila    Created
 */
 
package org.media.datastore.xmlrpcserver;

import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.Block; 

import org.apache.xmlrpc.WebServer; 
import org.apache.xmlrpc.XmlRpc;

import java.io.IOException;
import java.util.Vector;

/**
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila </a>
 * @version $Revision: 1.8 $ $Date: 2001/04/21 15:00:00
 * @see java.lang.String
 * @see org.apache.avalon.framework.configuration.Configurable
 * @see org.apache.avalon.framework.activity.Startable
 * @see org.apache.avalon.phoenix.Block
 */

public class XmlRpcServer extends AbstractLogEnabled 
    implements Block, Configurable, Startable {

    int PORT;
    String HANDLER_LABEL;
    Object HANDLER_CLASS;
    HandlerProperties hp;
    Vector vector = new Vector();


    class HandlerProperties {

        private String _hLabel;
        private Object _class;

        HandlerProperties( String hLabel, String hClass) throws Exception {
            _class = Class.forName( hClass ).newInstance();
            _hLabel = hLabel;
        }

        String getHandlerLabel() {
            return _hLabel;
        }

        Object getHandlerObject() {
            return _class;
        }
    }


    public void configure( final Configuration configuration )
        throws ConfigurationException {

        Configuration[] allChildrenNodes;
        Configuration[] handlers = null;
        String tagName;

        try {
            allChildrenNodes  = configuration.getChildren();
            for (int cx = 0; cx < allChildrenNodes.length; cx++ ) {
                tagName = allChildrenNodes[cx].getName();
                if ( tagName.equalsIgnoreCase("connection") ) {
                    String sPort = allChildrenNodes[cx].getAttribute("port");
                    PORT = Integer.parseInt(sPort);
                }
                if ( tagName.equalsIgnoreCase("handlers") ) {
                    handlers =  allChildrenNodes[cx].getChildren();
                }
            }
            for (int cy = 0; cy < handlers.length; cy++ ) {
                hp = new HandlerProperties( handlers[cy].getAttribute("name"),
                                            handlers[cy].getAttribute("class") );
                vector.addElement( hp );
            }
        } catch (Exception e) {
            getLogger().info("XmlRpcServer conf. error:" + e.getMessage());
            System.err.println("XmlRpcServer configuration error!");
        }
        getLogger().info("XmlRpcServer has been configured.");
    }


    public void start() throws Exception {
        try {
            WebServer server = new WebServer(PORT);
            for (int cx = 0; cx < vector.size(); cx++) {
                hp = ( HandlerProperties ) vector.get(cx);              
                server.addHandler( hp.getHandlerLabel(), hp.getHandlerObject() );
                getLogger().info("Loading handler: name=" + hp.getHandlerLabel() +
                                 " class=" + hp.getHandlerObject() );
            }
            getLogger().info(  "XmlRpc Server is operational..." );
            System.err.println("XmlRpc Server is operational...");
            System.err.println("\nAll services was loaded and Datastore is up\n");
        } catch ( IOException e ) {
            getLogger().info( "XmlRpc Server error:" + e.getMessage() );
        }
    }


    public void stop() throws Exception {
        getLogger().info(  "XmlRpc Server is down..." );
        System.err.println("XmlRpc Server is down.\n");
    }
}
