/*
 * $COPYRIGHT$
 * $Id: SepHandler.java,v 1.5 2002/05/25 16:06:08 crow Exp $
 *
 * Date         Author          Changes
 * May 28 2001  Antal Attila    Created
 */
 
package org.media.datastore.xmlrpcserver.handlers;

import org.media.datastore.sepengine.SepInterpreter;
import org.media.datastore.sepengine.driver.*;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.InputStream;

/**
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila</a>
 * @version $Revision: 1.5 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 */
     
public class SepHandler {

    protected SepStoreConnection con = null;    
   

    protected void openConnection(String dbName, String user, String pwd) {
        try {
            String _pwd = new SepInterpreter().preDigest( pwd );
            _pwd = new SepInterpreter().getPasswdHash( _pwd );
            System.setProperty("sep.drivers",
                               "org.media.datastore.sepengine.driver.localDriver.LocalDriver");
            String url = "sep:local:" + dbName;
            con = SepStoreDriverManager.getConnection(url, dbName + "_" + user, _pwd);
        }
        catch ( Exception e ) {
            e.printStackTrace();
        }
    }
    

    protected void closeConnection() {
        try {
            con.close();
        }
        catch ( Exception e ) {
            e.printStackTrace();
        }
    }


    public String execute( String sep, String dbName, String user, String pwd) {
        String ret = "";
	
        openConnection(dbName, user, pwd);
        try {
            InputStream is = con.executeSEP( sep );
            BufferedReader reader = new BufferedReader( new InputStreamReader ( is ) );
            String line = null;
            while ( ( line = reader.readLine() ) != null ) {
                ret += line + "\n";
            }
        }
        catch (Exception e){
            System.out.println("Error occured while returning data:" + e.getMessage());
        }
        closeConnection();
        return ret;
    }
}
