/*
 * $COPYRIGHT$
 * $Id: UrlHandler.java,v 1.5 2002/01/23 09:54:53 crow Exp $
 *
 * Date         Author          Changes
 * May 28 2001  Antal Attila    Created
 */
 
package org.media.datastore.xmlrpcserver.handlers;

import org.media.datastore.sepengine.driver.*;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.InputStream;
import java.util.Vector;
import org.apache.xmlrpc.AuthenticatedXmlRpcHandler;

/**
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila</a>
 * @version $Revision: 1.5 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 */
     
public class UrlHandler implements AuthenticatedXmlRpcHandler {

    private SepStoreConnection con = null;    


    public Object execute(String methodName, Vector parameters,
			  String username, String password) throws Exception {
	if (checkPassword(username, password)) {
	    return execute(methodName, parameters);
	} else {
	    throw new Exception( "Unauthorized user for: " + methodName );
	}
    }


    protected Object execute(String methodName, Vector params)
	throws Exception {
	if ( "executeSep".equals(methodName) ) {
	    String sep  = (String) params.elementAt(0);
	    String db   = (String) params.elementAt(1);
	    String user = (String) params.elementAt(2);
	    String hash = (String) params.elementAt(3);
	    return executeSep( sep, db, user, hash );
	}
	else if ( "echo".equals(methodName) ) return echo( (String) params.elementAt(0) );
	else throw new Exception("No such method: " + methodName );
    }  


    private String echo( String param ) {
	return param;
    }


    private String executeSep( String sep, String db, String user, String hash ) {
        String ret = "";
	openConnection( db, user, hash);
        try {
            InputStream is = con.executeSEP( sep );
            BufferedReader reader = new BufferedReader( new InputStreamReader ( is ) );
            String line = null;
            while ( ( line = reader.readLine() ) != null ) {
                ret += line + "\n";
            }
        }
        catch (Exception e){
            System.out.println("Error occured while returning data:" + e.getMessage());
        }
        closeConnection();
        return ret;
    }
    
  
    private void openConnection( String dbName, String user, String hash ) {
        try {
            System.setProperty("sep.drivers",
			       "org.media.datastore.sepengine.driver.localDriver.LocalDriver");
            String url = "sep:local:" + dbName;
	    String userFile = dbName + "_" + user;
            con = SepStoreDriverManager.getConnection(url, userFile, hash);
        }
        catch ( Exception e ) {
            e.printStackTrace();
        }
    }
    

    private void closeConnection() {
        try {
            con.close();
        }
        catch ( Exception e ) {
            e.printStackTrace();
        }
    }


    /*
     * Of course this method is only an example for testing.
     * You need to use a more sophisticated password checking
     * method.
     *
     */
    private boolean checkPassword( String user, String pwd ) {
	if ( user != null && pwd != null ) {
	    if ( user.equals(pwd) ) return true;
	    return false;
	}
	if ( user == null && pwd == null ) return true;
	return false;
    }
}

