/* 
 * $COPYRIGHT$
 * $Id: AllTests.java,v 1.21 2001/09/21 16:17:56 atech Exp $
 *
 * Date        Author            Changes 
 * Apr 27 2001 Szabo Csaba       Created
 * Mai 23 2001 Antal Attila      Modified
 */

package org.media.datastore.test;

import junit.framework.*;

/**
 * Class meant to run all the Test Suites related to datastore project.
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba</a>
 * @version $Revision: 1.21 $ $Date: 2001/09/21 16:17:56 $
 * @see java.lang.String
 */

public class AllTests {


    public static Test suite () {
        TestSuite suite= new TestSuite("All JUnit Tests for Datastore");
        suite.addTest (org.media.sep.test.AllInterpreterTestCase.suite());
        //suite.addTest (org.media.sep.test.util.AllDbHandlerTestCase.suite());
        suite.addTest (org.media.sep.test.DeleteTestCase.suite());
        suite.addTest (org.media.sep.test.parser.AllParserTestSuite.suite());
        suite.addTest (org.media.datastore.test.sepengine.AllSepengineTestSuite.suite());
        suite.addTest (org.media.datastore.test.beepserver.AllBeepserverTestSuite.suite());
        return suite;
    }

    
    public static void main (String[] args) {
        junit.textui.TestRunner.run ( suite() );
    }

}

