/* 
 * $COPYRIGHT$
 * $Id: BeepLogTestCase.java,v 1.3 2002/03/25 12:06:23 atech Exp $
 *
 * Date        Author            Changes 
 * May 23 2001 Antal Attila      Created
 */

package org.media.datastore.test.beepserver;

import junit.framework.*;
import org.media.datastore.beepserver.BeepLog;


/**
 * Class implementing a Test Case for the Sep Lexer class.
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila</a>
 * @version $Revision: 1.3 $ $Date: 2002/03/25 12:06:23 $
 */

public class BeepLogTestCase extends TestCase {


    public BeepLogTestCase (String name){
        super (name);
    }


    public static Test suite () {
	TestSuite suite = new TestSuite();                                      
        suite.addTest(new BeepLogTestCase("allMethods"));
        return suite;
    }


    public void allMethods() {
        try {
	    BeepLog bl = new BeepLog();
	    bl.setSeverity(1);
	    if (!bl.isLogged(1)) { assertTrue("isLogged", false); return; }
	    bl.startLogging("informational");
	    bl.logEntry(1,"Test Service", "This is a test!");
	    bl.logEntry(1,"Test Service", new Throwable("Just another test!") );
	    assertTrue("all methods is OK", true);
        } catch (Exception ex) {            
            ex.printStackTrace();
            assertTrue ("", false );
        }
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite());
    }
}
