/* 
 * $COPYRIGHT$
 * $Id: ChmodInfoTestCase.java,v 1.2 2002/03/25 12:06:23 atech Exp $
 *
 * Date        Author            Changes 
 * May 23 2001 Antal Attila      Created
 */

package org.media.datastore.test.sepengine;

import junit.framework.*;
import org.media.datastore.sepengine.ChmodInfo;


/**
 * Class implementing a Test Case for the Sep Lexer class.
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila</a>
 * @version $Revision: 1.2 $ $Date: 2002/03/25 12:06:23 $
 */

public class ChmodInfoTestCase extends TestCase {


    public ChmodInfoTestCase (String name){
        super (name);
    }


    public static Test suite () {
	TestSuite suite = new TestSuite();                                      
        suite.addTest(new ChmodInfoTestCase("allMethods"));
        return suite;
    }


    public void allMethods() {
        try {
	    ChmodInfo cm = new ChmodInfo();
	    cm.setDoc("Test");
	    cm.setMode("Test");
	    cm.setRecursive(true);
	    cm.setVerbose(true);
	    if (!(cm.getDoc()).equals("Test"))  { assertTrue("getDoc",false); return; }
	    if (!(cm.getMode()).equals("Test")) { assertTrue("getMode",false); return; }
	    if (!cm.isRecursive()) { assertTrue("isRecursive",false); return; }	    
	    if (!cm.isVerbose())   { assertTrue("isVerbose",false); return; }
	    String s = cm.toString();
	    assertTrue("all methods is OK", true);
        } catch (Exception ex) {            
            ex.printStackTrace();
            assertTrue ("", false );
        }
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite());
    }
}
