/* 
 * $COPYRIGHT$
 * $Id: ChownInfoTestCase.java,v 1.2 2002/03/25 12:06:23 atech Exp $
 *
 * Date        Author            Changes 
 * May 23 2001 Antal Attila      Created
 */

package org.media.datastore.test.sepengine;

import junit.framework.*;
import org.media.datastore.sepengine.ChownInfo;


/**
 * Class implementing a Test Case for the Sep Lexer class.
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila</a>
 * @version $Revision: 1.2 $ $Date: 2002/03/25 12:06:23 $
 */

public class ChownInfoTestCase extends TestCase {


    public ChownInfoTestCase (String name){
        super (name);
    }


    public static Test suite () {
	TestSuite suite = new TestSuite();                                      
        suite.addTest(new ChownInfoTestCase("allMethods"));
        return suite;
    }


    public void allMethods() {
        try {
	    ChownInfo cm = new ChownInfo();
	    cm.setDoc("Test");
	    cm.setOwner("Test");
	    cm.setRecursive(true);
	    cm.setVerbose(true);
	    if (!(cm.getDoc()).equals("Test"))  { assertTrue("getDoc",false); return; }
	    if (!(cm.getOwner()).equals("Test")) { assertTrue("getMode",false); return; }
	    if (!cm.isRecursive()) { assertTrue("isRecursive",false); return; }	    
	    if (!cm.isVerbose())   { assertTrue("isVerbose",false); return; }
	    String s = cm.toString();
	    assertTrue("all methods is OK", true);
        } catch (Exception ex) {            
            ex.printStackTrace();
            assertTrue ("", false );
        }
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite());
    }
}
