/* 
 * $COPYRIGHT$
 * $Id: DTDDirInfoTestCase.java,v 1.3 2002/05/17 12:42:30 crow Exp $
 *
 * Date        Author            Changes 
 * May 23 2001 Antal Attila      Created
 */

package org.media.datastore.test.sepengine;

import junit.framework.*;
import org.media.datastore.sepengine.DTDDirInfo;


/**
 * Class implementing a Test Case for the Sep Lexer class.
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila</a>
 * @version $Revision: 1.3 $ $Date: 2002/05/17 12:42:30 $
 */

public class DTDDirInfoTestCase extends TestCase {


    public DTDDirInfoTestCase (String name){
        super (name);
    }


    public static Test suite () {
	TestSuite suite = new TestSuite();                                      
        suite.addTest(new DTDDirInfoTestCase("allMethods"));
        return suite;
    }


    public void allMethods() {
        try {
	    DTDDirInfo cm = new DTDDirInfo("path","mode", "naming", true);
	    if (!(cm.getDTDPath()).equals("path"))   { assertTrue("getDTDPath",false); return; }
	    if (!(cm.getStoreMode()).equals("mode")) { assertTrue("getStoreMode",false); return; }
	    if (!(cm.getNamingFlag()).equals("naming")) { assertTrue("getNamingFlag",false); return; }
	    if (!cm.isIgnoredTag())                  { assertTrue("isIgnoredTag",false); return; }	    
	    assertTrue("all methods is OK", true);
        } catch (Exception ex) {            
            ex.printStackTrace();
            assertTrue ("", false );
        }
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite());
    }
}
