/* 
 * $COPYRIGHT$
 * $Id: LexiconManagerTestCase.java,v 1.2 2002/03/25 12:06:23 atech Exp $
 *
 * Date        Author            Changes 
 * May 23 2001 Antal Attila      Created
 */

package org.media.datastore.test.sepengine;

import junit.framework.*;
import org.media.datastore.sepengine.LexiconManager;


/**
 * Class implementing a Test Case for the Sep Lexer class.
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila</a>
 * @version $Revision: 1.2 $ $Date: 2002/03/25 12:06:23 $
 */

public class LexiconManagerTestCase extends TestCase {


    public LexiconManagerTestCase (String name){
        super (name);
    }


    public static Test suite () {
	TestSuite suite = new TestSuite();                                      
        suite.addTest(new LexiconManagerTestCase("runManager1"));
        suite.addTest(new LexiconManagerTestCase("runManager2"));
        suite.addTest(new LexiconManagerTestCase("target"));
        return suite;
    }


    public void runManager1() {
        try {
	    LexiconManager lm = new LexiconManager();
	    lm.runLexiconManager(false);
	    assertTrue ("Lexicon manager can start.", true );
        } catch (Exception ex) {            
            ex.printStackTrace();
            assertTrue ("Lexicon manager can't start", false );
        }
    }

    public void runManager2() {
        try {
	    LexiconManager lm = new LexiconManager();
	    lm.runLexiconManager(false,false);
	    assertTrue ("Lexicon manager can start.", true );
        } catch (Exception ex) {            
            ex.printStackTrace();
            assertTrue ("Lexicon manager can't start", false );
        }
    }

    public void target() {
        try {
	    LexiconManager lm = new LexiconManager();
	    lm.targetTriggered("test");
	    assertTrue ("Target in Lexicon manager can start.", true );
        } catch (Exception ex) {            
            ex.printStackTrace();
            assertTrue ("Target in Lexicon manager can't start", false );
        }
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite());
    }
}
