/* 
 * $COPYRIGHT$
 * $Id: LogManagerTestCase.java,v 1.6 2002/03/25 12:06:23 atech Exp $
 *
 * Date        Author            Changes 
 * May 23 2001 Antal Attila      Created
 */

package org.media.datastore.test.sepengine;

import junit.framework.*;
import org.media.datastore.sepengine.LogManager;


/**
 * Class implementing a Test Case for the Sep Lexer class.
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila</a>
 * @version $Revision: 1.6 $ $Date: 2002/03/25 12:06:23 $
 */

public class LogManagerTestCase extends TestCase {


    public LogManagerTestCase (String name){
        super (name);
    }


    public static Test suite () {
	TestSuite suite = new TestSuite();                                      
        suite.addTest(new LogManagerTestCase("getMessage"));
        suite.addTest(new LogManagerTestCase("message"));
        return suite;
    }


    public void getMessage() {
        try {
	    String msg = LogManager.getReference().getMessage("test");
	    assertTrue ("The log message can be read from properties file.", true );
        } catch (Exception ex) {            
            ex.printStackTrace();
            assertTrue ("The log message can't be read from properties file", false );
        }
    }

    public void message() {
        try {
	    LogManager.getReference().message("info","test");
	    LogManager.getReference().message("warn","test");
	    LogManager.getReference().message("error","test");
	    assertTrue ("The log message can be read from properties file.", true );
        } catch (Exception ex) {            
            ex.printStackTrace();
            assertTrue ("The log message can't be read from properties file", false );
        }
    }


    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite());
    }
}
