/* 
 * $COPYRIGHT$
 * $Id: RDBInfoTestCase.java,v 1.3 2002/05/17 12:42:30 crow Exp $
 *
 * Date        Author            Changes 
 * May 23 2001 Antal Attila      Created
 */

package org.media.datastore.test.sepengine;

import junit.framework.*;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Vector;
import org.media.datastore.sepengine.DTDDirInfo;
import org.media.datastore.sepengine.RDBInfo;


/**
 * Class implementing a Test Case for the Sep Lexer class.
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila</a>
 * @version $Revision: 1.3 $ $Date: 2002/05/17 12:42:30 $
 */

public class RDBInfoTestCase extends TestCase {


    public RDBInfoTestCase (String name){
        super (name);
    }


    public static Test suite () {
	TestSuite suite = new TestSuite();                                      
        suite.addTest(new RDBInfoTestCase("allMethods"));
        return suite;
    }


    public void allMethods() {
        try {
	    Connection con = null;
	    DTDDirInfo dtd = new DTDDirInfo("path", "mode", "naming", true);
	    Vector ikey = new Vector();
	    Vector skey = new Vector();
	    RDBInfo cm = new RDBInfo("TestDB", dtd, con, ikey, skey);
	    Connection t_con = cm.getConnection();
	    DTDDirInfo t_dtd = cm.getDTDDirInfo();
	    Vector t_ikey = cm.getIgnoredKeys();
	    Vector t_skey = cm.getSpecialKeys();
	    if (!(cm.getName()).equals("TestDB")) { assertTrue("getName",false); return; }
	    assertTrue("all methods is OK", true);
        } catch (Exception ex) {            
            ex.printStackTrace();
            assertTrue ("", false );
        }
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite());
    }
}
