/* 
 * $COPYRIGHT$
 * $Id: TreeInfoTestCase.java,v 1.2 2002/03/25 12:06:23 atech Exp $
 *
 * Date        Author            Changes 
 * May 23 2001 Antal Attila      Created
 */

package org.media.datastore.test.sepengine;

import junit.framework.*;
import org.media.datastore.sepengine.TreeInfo;


/**
 * Class implementing a Test Case for the Sep Lexer class.
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila</a>
 * @version $Revision: 1.2 $ $Date: 2002/03/25 12:06:23 $
 */

public class TreeInfoTestCase extends TestCase {


    public TreeInfoTestCase (String name){
        super (name);
    }


    public static Test suite () {
	TestSuite suite = new TestSuite();                                      
        suite.addTest(new TreeInfoTestCase("allMethods"));
        return suite;
    }


    public void allMethods() {
        try {
	    TreeInfo cm = new TreeInfo();
	    cm.setAction("Test");
	    cm.setDestination("Test");
	    cm.setForced(true);
	    cm.setLongFormat(true);
	    cm.setRecursive(true);
	    cm.setSource("Test");
	    cm.setSubtreeName("Test");
	    cm.setTreeList(true);
	    cm.setVerboseMode(true);
	    if (!(cm.getAction()).equals("Test")) { assertTrue("getAction",false); return; }
	    if (!(cm.getDestination()).equals("Test")) { assertTrue("getDestination",false); return; }
	    if (!cm.isForced()) { assertTrue("isForced",false); return; }
	    if (!cm.isLongFormat()) { assertTrue("isLongFormat",false); return; }	    
	    if (!cm.isRecursive()) { assertTrue("isRecursive",false); return; }
	    if (!(cm.getSource()).equals("Test")) { assertTrue("getSource",false); return; }
	    if (!(cm.getSubtreeName()).equals("Test")) { assertTrue("getSubtreeName",false); return; }
	    if (!cm.isTreeList()) { assertTrue("isTreeList",false); return; }
	    if (!cm.isVerboseMode())   { assertTrue("isVerboseMode",false); return; }
	    String s = cm.toString();
	    assertTrue("all methods is OK", true);
        } catch (Exception ex) {            
            ex.printStackTrace();
            assertTrue ("", false );
        }
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite());
    }
}
