/* 
 * $COPYRIGHT$
 * $Id: UserInfoTestCase.java,v 1.2 2002/03/25 12:06:23 atech Exp $
 *
 * Date        Author            Changes 
 * May 23 2001 Antal Attila      Created
 */

package org.media.datastore.test.sepengine;

import junit.framework.*;
import java.util.Vector;
import org.media.datastore.sepengine.UserInfo;


/**
 * Class implementing a Test Case for the Sep Lexer class.
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila</a>
 * @version $Revision: 1.2 $ $Date: 2002/03/25 12:06:23 $
 */

public class UserInfoTestCase extends TestCase {


    public UserInfoTestCase (String name){
        super (name);
    }


    public static Test suite () {
	TestSuite suite = new TestSuite();                                      
        suite.addTest(new UserInfoTestCase("allMethods"));
        return suite;
    }


    public void allMethods() {
        try {
	    UserInfo cm = new UserInfo();
	    cm.addGroup("Test");
	    cm.setAction("Test");
	    cm.setHomedir("Test");
	    cm.setInitialgroup("Test");
	    cm.setLoginname("Test");
	    cm.setPassword("Test");
	    cm.setUsername("Test");
	    Vector v = cm.getGroups();
	    String s = (String) v.firstElement();
	    if (!s.equals("Test")) { assertTrue("getGroups",false); return; }
	    if (!(cm.getAction()).equals("Test")) { assertTrue("getAction",false); return; }
	    if (!(cm.getHomedir()).equals("Test")) { assertTrue("getHomedir",false); return; }
	    if (!(cm.getInitialgroup()).equals("Test")) { assertTrue("getInitialGroup",false); return; }
	    if (!(cm.getLoginName()).equals("Test")) { assertTrue("getLoginname",false); return; }
	    if (!(cm.getPassword()).equals("Test")) { assertTrue("getPassword",false); return; }
	    if (!(cm.getUserName()).equals("Test")) { assertTrue("getUsername",false); return; }
	    String ts = cm.toString();
	    assertTrue("all methods is OK", true);
        } catch (Exception ex) {            
            ex.printStackTrace();
            assertTrue ("", false );
        }
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite());
    }
}
