/* 
 * $COPYRIGHT$
 * $Id: LexerTestCase.java,v 1.12 2002/03/25 12:06:23 atech Exp $
 *
 * Date        Author            Changes 
 * May 23 2001 Antal Attila      Created
 */

package org.media.sep.test.parser;

import junit.framework.*;
import antlr.*;
import org.media.datastore.sepengine.parser.*;
import java.util.Vector;
import java.io.*;

/**
 * Class implementing a Test Case for the Sep Lexer class.
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila</a>
 * @version $Revision: 1.12 $ $Date: 2002/03/25 12:06:23 $
 */

public class LexerTestCase extends TestCase {

    private String _test_file_1 = "TestLexer.txt.tcf";
    private String _test_file_2 = "TestFetch.sep.tcf";


    public LexerTestCase (String name){
        super (name);
    }


    public static Test suite () {
        return new TestSuite (LexerTestCase.class);
    }


    /**
     * Simple test method which gives one particular token at a time from TestLexer.txt.tcf
     * file to the lexer, and verify's if the Lexer has produced the proper Token.
     */
    public void testTokensInSepLexer() {
        try {
            sepLexer lexer = new sepLexer( getClass().getResourceAsStream(_test_file_1) );
            Token token;
	    while ( (token = lexer.nextToken()) != null  && token.getText() != null ) {
                if ( token.getType() != sepLexer.WS )
                    switch (token.getLine()) {
                    case 1: {
                        assertTrue ("sepLexer.XVALUE, line 1", token.getType() == sepLexer.XVALUE);
                        break;                
                    }  
                    case 2: {
                        assertTrue ("sepLexer.REQUEST, line 2", token.getType() == sepLexer.REQUEST);
                        break;                
                    }  
                    case 3: {
                        assertTrue ("sepLexer.FETCH, line 3", token.getType() == sepLexer.FETCH);
                        break;                
                    }
                    case 4: {
                        assertTrue ("sepLexer.ORDERING, line 4", token.getType() == sepLexer.ORDERING);
                        break;                
                    }
                    case 5: {
                        assertTrue ("sepLexer.UNION, line 5", token.getType() == sepLexer.UNION);
                        break;                
                    }
                    case 6: {
                        assertTrue ("sepLexer.INTERSECT, line 6", token.getType() == sepLexer.INTERSECT);
                        break;                
                    }   
                    case 7: {
                        assertTrue ("sepLexer.COMPARE, line 7", token.getType() == sepLexer.COMPARE);
                        break;                
                    } 
                    case 8: {
                        assertTrue ("sepLexer.PATH, line 8", token.getType() == sepLexer.PATH);
                        break;                
                    }
                    case  9: {
                        assertTrue ("sepLexer.ELEMENT, line 9", token.getType() == sepLexer.ELEMENT);
                        break;                
                    }
                    case 10: {
                        assertTrue ("sepLexer.STORE, line 10", token.getType() == sepLexer.STORE);
                        break;                
                    }
                    case 11: {
                        assertTrue ("sepLexer.REQNO, line 11", token.getType() == sepLexer.REQNO);

                        break;                
                    }
                    case 12: {
                        assertTrue ("sepLexer.RELATED, line 12", token.getType() == sepLexer.RELATED);
                        break;                
                    }
                    case 13: {
                        assertTrue ("sepLexer.OFFSET, line 13", token.getType() == sepLexer.OFFSET);
                        break;                
                    }
                    case 14: {
                        assertTrue ("sepLexer.MAXNUM, line 14", token.getType() == sepLexer.MAXNUM);
                        break;                
                    }
                    case 15: {
                        assertTrue ("sepLexer.NOTIFICATION, line 15",
                                 token.getType() == sepLexer.NOTIFICATION);
                        break;                
                    }
                    case 16: {
                        assertTrue ("sepLexer.PREVSTAMP, line 16", token.getType() == sepLexer.PREVSTAMP);
                        break;                
                    }
                    case 17: {
                        assertTrue ("sepLexer.SUBTREE, line 17", token.getType() == sepLexer.SUBTREE);
                        break;                
                    }
                    case 18: {
                        assertTrue ("sepLexer.OPERATOR, line 18", token.getType() == sepLexer.OPERATOR);
                        break;                
                    }
                    case 19: {
                        assertTrue ("sepLexer.CASESENSITIVE, line 19",
                                 token.getType() == sepLexer.CASESENSITIVE);
                        break;                
                    }
                    case 20: {
                        assertTrue ("sepLexer.APPROXIMATE, line 20",
                                 token.getType() == sepLexer.APPROXIMATE);
                        break;                
                    }
                    case 21: {
                        assertTrue ("sepLexer.ATTRIBUTR, line 21", token.getType() == sepLexer.ATTRIBUTE);
                        break;                
                    }
                    case 22: {
                        assertTrue ("sepLexer.ORDER, line 22", token.getType() == sepLexer.ORDER);
                        break;                
                    }
                    case 23: {
                        assertTrue ("sepLexer.PROPERTY, line 23", token.getType() == sepLexer.PROPERTY);
                        break;                
                    } 
                    case 24: {
                        assertTrue ("sepLexer.ACTION, line 24", token.getType() == sepLexer.ACTION);
                        break;                
                    } 
                    case 25: {
                        assertTrue ("sepLexer.ET, line 25", token.getType() == sepLexer.ET);
                        break;                
                    }
                    case 26: {
                        assertTrue ("sepLexer.LT, line 26", token.getType() == sepLexer.LT);
                        break;                
                    }
                    case 27: {
                        assertTrue ("sepLexer.GT, line 27", token.getType() == sepLexer.GT);
                        break;                
                    }
                    case 28: {
                        assertTrue ("sepLexer.SL, line 28", token.getType() == sepLexer.SL);
                        break;                
                    }
                    case 29: {
                        assertTrue ("sepLexer.EQ, line 29", token.getType() == sepLexer.EQ);
                        break;                
                    }
                    case 30: {
                        assertTrue ("sepLexer.STRING, line 30", token.getType() == sepLexer.STRING);
                        break;                
                    }
                    case 31: {
                        assertTrue ("sepLexer.STRING, line 31", token.getType() == sepLexer.STRING);
                        break;                
                    }
		    }
            }
        } catch (Exception ex){
	    ex.printStackTrace();
        }
    }


    /**
     * Simple test method which gives to the lexer a whole script file "TestFetch.sep.tcf.
     * If there are problems with the lexer it will fail at lexing.
     */
    public void testSepLexer() {
        try {
            sepLexer lexer = new sepLexer( getClass().getResourceAsStream(_test_file_2) );
            Token token;
            while ( (token = lexer.nextToken()) != null && token.getText() != null );
	    assertTrue ("sepLexer parsed the sample script file:" + _test_file_2, true );
        } catch (Exception ex) {            
            ex.printStackTrace();
            assertTrue ("sepLexer failed to parse the sample script file:" + _test_file_2, false );
        }
    }


    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite());
    }
}
