/* 
 * $COPYRIGHT$
 * $Id: AllDbHandlerTestCase.java,v 1.20 2002/03/25 12:06:23 atech Exp $
 *
 * Date        Author            Changes 
 * Mai 23 2001 Antal Attila      Created
 */

package org.media.sep.test.util;

import junit.framework.*;
import java.sql.DriverManager;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import java.util.StringTokenizer;
import org.media.datastore.sepengine.util.SepDBHandler;

/**
 * Class meant to run all the Test Suites related to datastore project, 
 * SepDBHandler package.
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila</a>
 * @version $Revision: 1.20 $ $Date: 2002/03/25 12:06:23 $
 */

public class AllDbHandlerTestCase extends TestCase {

    private static SepDBHandler hd;


    public AllDbHandlerTestCase (String name){
        super (name);
    }

    
    public static Test suite () {
        TestSuite suite = new TestSuite();
        hd = new SepDBHandler(null, null, null);
        suite.addTest(new AllDbHandlerTestCase("isReady"));
        suite.addTest(new AllDbHandlerTestCase("getTreeID"));
        suite.addTest(new AllDbHandlerTestCase("isPath"));
        return suite;
    }

    
    public void isReady() {
        assertTrue(hd.isReady());
    }


    public void getTreeID() {
        assertTrue(hd.getTreeID("test.config") != -1);
        assertTrue(hd.getDocumentID("test.config") == -1);

        assertTrue(hd.getTreeID("test.config.xml") != -1);
        assertTrue(hd.getDocumentID("test.config.xml") == -1);
        
        assertTrue(hd.getTreeID("test.config.xml.10") == -1);
        assertTrue(hd.getDocumentID("test.config.xml.10") == -1);

        assertTrue(hd.getTreeID("test.config.xml.1") != -1);
        assertTrue(hd.getDocumentID("test.config.xml.1") == 1);
        
        assertTrue(hd.getTreeID("atech.1") == -1);
        assertTrue(hd.getDocumentID("atech.1") == -1);

        assertTrue(hd.getTreeID("1") == -1);
        assertTrue(hd.getDocumentID("1") == -1);
        
        assertTrue(hd.getTreeID("users.atech.email.1.1") == -1);
        assertTrue(hd.getDocumentID("users.atech.email.1.1") == -1);
        
        assertTrue(hd.getTreeID("1.users.atech.email") == -1);
        assertTrue(hd.getDocumentID("1.users.atech.email") == -1);
        
        assertTrue(hd.getTreeID("crow.icq") == -1);
    }

    
    public void isPath() {
        assertTrue(hd.isPath("avalon:myblock"));
        assertTrue(hd.isPath("avalon:myblock;name"));
        assertTrue(hd.isPath("avalon:myblock;class"));
        assertTrue(hd.isPath("avalon:myblock:logger;name"));
        assertTrue(hd.isPath(";name"));
        assertTrue(!hd.isPath("crow:icq"));
        assertTrue(!hd.isPath("email:from:name"));
        assertTrue(!hd.isPath("email;from;name"));
        assertTrue(!hd.isPath(";name;surname"));
        assertTrue(!hd.isPath(";users"));
    }


    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite());
    }
}
