<?xml version="1.0"?>

<!-- ================================================================

$COPYRIGHT$

$Id: book2html.xsl,v 1.1 2001/08/07 11:59:05 atech Exp $

Desc:
This style, takes the whole book file as generate by the bookfixup 
style and generates a book. It mainly use the templates from 
document, which is imported.

Date        Author            Changes
Jul 01 2001 Remus Pereni      Created

================================================================= -->

<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0"
  xmlns:lxslt="http://xml.apache.org/xslt"
  xmlns:redirect="org.apache.xalan.xslt.extensions.Redirect"
  extension-element-prefixes="redirect">
  
<xsl:import 
  href="document2html.xsl"/>

<xsl:param 
  name="bookdir" />

<xsl:param 
  name="docNav" />


<!-- ====================================================================== -->
<!-- book section                                                           -->
<!-- ====================================================================== -->
<xsl:template match="book">
  <html>
    <xsl:call-template name="header"/>
    <xsl:call-template name="body"/>
    <xsl:call-template name="chapter"/>
  </html>
</xsl:template>


<!-- ====================================================================== -->
<!-- chapter section                                                        -->
<!-- ====================================================================== -->
<xsl:template name="chapter">
  <xsl:for-each select="//chapter">
    <redirect:write select="concat($bookdir, @file, '.html')" >
      <xsl:apply-templates select="document">
        <xsl:with-param name="type" select="self::node()"/>
      </xsl:apply-templates>
    </redirect:write>
  </xsl:for-each>
</xsl:template>


<!-- ====================================================================== -->
<!-- body section  (this will be the first page which contains the TOC      -->
<!-- ====================================================================== -->
<xsl:template name="body">
  <body topmargin="4" leftmargin="4" marginheight="4" marginwidth="4">
    <table width="95%" align="center">
      <tr>
        <td align="center">
          <a name="top">
            <xsl:call-template name="docInfos">
              <xsl:with-param name="type" select="'simple_doc'"/>
            </xsl:call-template>
          </a>    
        </td>
      </tr>
      <xsl:call-template name="navline" />         
        <tr>
          <td align="center">
            <H1><xsl:value-of select="/book/header/title"/></H1>
          </td>
        </tr>
        <tr>
          <td>
            <xsl:call-template name="bookToc"/>
          </td>
        </tr>
        <tr>
          <td align="center"><xsl:call-template name="footer"/></td>
        </tr>
      </table>
    </body>
</xsl:template>



<!-- ====================================================================== -->
<!-- TOC section  (this will be the first page, on the rest is used toc     -->
<!-- ====================================================================== -->
<xsl:template name="bookToc">
  <strong>Table of Contents</strong>
  <table border="0" cellspacing="0" cellpadding="0">
    <tr>  
    <td align="left" valign="top" class="toc">
      <table border="0" cellpadding="1" cellspacing="1">
        <xsl:for-each select="//chapter|//s2|//s3|//s4">
          <tr><td>
          
          <xsl:if test="local-name(.)='chapter'">
            <br/>
          </xsl:if>

          <!-- we make the indentation with spaces -->
          <xsl:if test="local-name(.)='s2'">   
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>            
          </xsl:if>

          <xsl:if test="local-name(.)='s3'">   
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
          </xsl:if>

          <xsl:if test="local-name(.)='s4'">   
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
          </xsl:if>

          <!-- the numbering in the toc -->
          <xsl:number 
            format="1.1.1.1." 
            level="multiple"
            count="chapter|s2|s3|s4" />
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <xsl:variable name="chapter" select="ancestor-or-self::chapter/@file" />
              <a href="{$chapter}.html#{generate-id(.)}"> <xsl:value-of select="@title" /></a>
            </td></tr>

    </xsl:for-each>
  </table>
</td>
</tr>
</table>
</xsl:template>


</xsl:stylesheet>