<?xml version="1.0"?>

<!-- ================================================================

$COPYRIGHT$

$Id: changelog2document.xsl,v 1.4 2002/05/06 04:53:17 neuro Exp $

Date        Author            Changes
Jun 26 2001 Remus Pereni      Created

================================================================= -->

<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">

<xsl:import href="copyover.xsl"/>

<xsl:output method="xml" />

<!-- ====================================================================== -->
<!-- document section                                                       -->
<!-- ====================================================================== -->

<xsl:template match="changes">
  <document>
    <xsl:apply-templates/>
  </document>
</xsl:template>

<xsl:template match="body">
  <body>
    <s1 title="Datastore - History of Changes">
      <xsl:apply-templates/>
      <s2 title="Legend">
        <anchor id="legend">
        </anchor>
        <table>
          <tr>
            <td>
              <img src="images/green8x8.gif" alt="[Update]:" /> 
                <xsl:text>  -  Update </xsl:text>
            </td>
            <td>
              <img src="images/blue8x8.gif" alt="[Add]:" /> 
                <xsl:text>  -  Add </xsl:text>
            </td>
            <td>
              <img src="images/gray8x8.gif" alt="[Remove]:" /> 
                <xsl:text>  -  Remove </xsl:text>
            </td>
            <td>
              <img src="images/red8x8.gif" alt="[Fix]:" /> 
                <xsl:text>  -  Fix </xsl:text>
            </td>
          </tr>
        </table>
      </s2>
    </s1>
  </body>
</xsl:template>


<!-- ====================================================================== -->
<!-- release section                                                        -->
<!-- ====================================================================== -->

<xsl:template match="release">
  <s2 title="Version {@version} ({@date})">
    <xsl:apply-templates/>
  </s2>
</xsl:template>


<!-- ====================================================================== -->
<!-- Action section                                                         -->
<!-- ====================================================================== -->

<xsl:template match="action">
  <p align="left">
    <xsl:choose>

      <xsl:when test="@type='update'">
        <jump anchor="legend" title="Update">
          <img src="images/green8x8.gif" alt="[Update]" />           
        </jump>
      </xsl:when>

      <xsl:when test="@type='add'">
        <jump anchor="legend" title="Add">
          <img src="images/blue8x8.gif" alt="[Add]" />
        </jump>
      </xsl:when>

      <xsl:when test="@type='fix'">
        <jump anchor="legend" title="Fix">
          <img src="images/red8x8.gif" alt="[Fix]" />
        </jump>
      </xsl:when>
      
      <xsl:when test="@type='remove'">
        <jump anchor="legend" title="Remove">
          <img src="images/gray8x8.gif" alt="[Remove]"/>
        </jump>
      </xsl:when>

    </xsl:choose>
    <xsl:value-of select="."/>

    <!-- Fixes bug  -->
    <xsl:if test="@fixes-bug">
      <xsl:text>Fixes bug nr: </xsl:text>
      <xsl:value-of select="./@fixes-bug"/>
      <xsl:text>. </xsl:text>
    </xsl:if>

    <!-- Thanks to ...  -->
    <xsl:choose>       

    <xsl:when test="@due-to and @due-to-email">
      <xsl:text>Thanks to </xsl:text> 
      <link href="mailto:{@due-to-email}">
        <xsl:value-of select="./@due-to"/>
      </link>
      <xsl:text>. </xsl:text> 
    </xsl:when>

    <xsl:when test="@due-to">
      <xsl:text>Thanks to </xsl:text> 
      <xsl:value-of select="./@due-to"/>
      <xsl:text>. </xsl:text> 
    </xsl:when>
    
    <xsl:when test="@due-to-email">
      <xsl:text>Thanks to </xsl:text> 
      <link href="mailto:{@due-to-email}">
        <xsl:text disable-output-escaping='yes'>&amp;lt;</xsl:text>
        <xsl:value-of select="./@due-to-email"/>
        <xsl:text disable-output-escaping='yes'>&amp;gt;</xsl:text>
      </link>
      <xsl:text>. </xsl:text> 
    </xsl:when>

  </xsl:choose>

  <!-- Done by  -->
  <xsl:text> [</xsl:text>
  <link href="{concat('credits.html#', ./@dev)}"><xsl:value-of select="./@dev"/></link>
  <xsl:text>] </xsl:text>
  
</p>
</xsl:template>

</xsl:stylesheet>