<?xml version="1.0"?>

<!-- ================================================================

$COPYRIGHT$

$Id: document2html.xsl,v 1.2 2001/08/13 09:49:00 neuro Exp $

Description:
This is the piece of resistance. Here are defined the basic templates
where are used almost everywhere. In some cases, depending on the 
situation some of this templates are overridden.

Date        Author            Changes
Jun 26 2001 Remus Pereni      Created

================================================================= -->

<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0"
  xmlns:xalan="org.apache.xalan.lib.Extensions"
  extension-element-prefixes="xalan"
  exclude-result-prefixes="xalan">

  
<xsl:import href="copyover.xsl"/>

<xsl:param name="copyright"/>
<xsl:param name="id"/>
<xsl:param name="path2root"/>
<xsl:param name="docCSS">datastore.css</xsl:param>
<xsl:param name="docNav"/>

<xsl:key name="s1" 
  match="//s1|//s2|//s3|//s4" 
  use="@title" />

<xsl:output 
  encoding="iso-8859-1"
  doctype-public='-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd'
  method="html"/>


<!-- ====================================================================== -->
<!-- document section                                                       -->
<!-- ====================================================================== -->
<xsl:template match="document">
  <xsl:param name="type" select="'simple_doc'"/>
  <html>
    <xsl:apply-templates>
      <xsl:with-param name="type" select="$type"/>
    </xsl:apply-templates>
  </html>
</xsl:template>


<!-- ====================================================================== -->
<!-- header section                                                         -->
<!-- ====================================================================== -->
<xsl:template match="header" name="header">
  <head>
    <title><xsl:value-of select="//title"/></title>
    <link rel="stylesheet" type="text/css" href="{$path2root}resources/{$docCSS}" title="Simple Style"/>
  </head>
</xsl:template>


<!-- ====================================================================== -->
<!-- body section                                                           -->
<!-- ====================================================================== -->
<xsl:template match="body" name="body">
  <xsl:param name="type"/>
  <body>
    <table width="100%" align="center" cellspacing="0" cellpadding="0" border="0">
      <tr>
        <td align="center">
          <a name="top">
            <xsl:call-template name="docInfos">
              <xsl:with-param name="type" select="$type"/>
            </xsl:call-template>
          </a>    
        </td>
      </tr>
      <xsl:call-template name="navline" />         
      </table>
      <xsl:apply-templates/>      
      <div align="center">
        <xsl:call-template name="footer"/>
      </div>  
    </body>
</xsl:template>


<!-- S1 -->
<xsl:template match="s1">
  <h1><a name="{generate-id(.)}"><xsl:value-of select="@title"/></a></h1>
  <xsl:call-template name="authors"/>
  <xsl:call-template name="toc">
    <xsl:with-param name="document" select="ancestor::document" />
  </xsl:call-template>
  <xsl:apply-templates/>
  <xsl:call-template name="totop" />
</xsl:template>


<!-- S2 -->
<xsl:template match="s2">
  <h2>
    <xsl:call-template name="numbering" />
    <a name="{generate-id(.)}"><xsl:value-of select="@title"/></a>
  </h2>
  <xsl:apply-templates/>
  <xsl:if test="following-sibling::s2">
    <xsl:call-template name="totop" />
  </xsl:if>
</xsl:template>


<!-- S3 -->
<xsl:template match="s3">
  <h3>
    <xsl:call-template name="numbering" />
    <a name="{generate-id(.)}"><xsl:value-of select="@title"/></a>
  </h3>
  <xsl:apply-templates/>
  <xsl:if test="following-sibling::s3">
    <xsl:call-template name="totop" />
  </xsl:if>
</xsl:template>


<!-- S4 -->
<xsl:template match="s4">
  <h4>
    <xsl:call-template name="numbering" />
    <a name="{generate-id(.)}"><xsl:value-of select="@title"/></a>
  </h4>
  <xsl:apply-templates/>
  <xsl:if test="following-sibling::s4">
    <xsl:call-template name="totop" />
  </xsl:if>
</xsl:template>


<!-- ====================================================================== -->
<!-- footer section                                                         -->
<!-- ====================================================================== -->
<xsl:template match="footer" name="footer">
  <tr>
    <td align="center">
      <p class="copyright">
        <hr noshade="noshade" size="1" width="100%"/><br/>
        &#169; 2001
      </p>
    </td>
  </tr>
</xsl:template>


<!-- ====================================================================== -->
<!-- note section                                                           -->
<!-- ====================================================================== -->
<xsl:template match="note">

  <div align="center">
    <table width="80%" align="center" border="0" cellpadding="1" cellspacing="1">
      <tr>
        <td align="left" class="note">
          <b>Note:</b><font color="#333333">
          <xsl:apply-templates/>
        </font>
        </td>
      </tr>
    </table>
  </div>

</xsl:template>


<!-- ====================================================================== -->
<!-- source section                                                         -->
<!-- ====================================================================== -->
<xsl:template match="source">
  <table bgcolor="#cccccc" cellpadding="1" cellspacing="1" border="0" align="center" width="90%">
    <tr>
      <td>
        <table bgcolor="#ffffff" border="0" align="left" width="100%">
          <tr>
            <td>
              <pre class="source">
                <xsl:apply-templates/>
              </pre>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
</xsl:template>


<xsl:template match="fixme">
<!-- ignore on documentation -->
</xsl:template>


<!-- ====================================================================== -->
<!-- paragraph section                                                      -->
<!-- ====================================================================== -->
<xsl:template match="p">
  <p align="left">
    <xsl:apply-templates/>
  </p>
</xsl:template>


<!-- ====================================================================== -->
<!-- list section                                                           -->
<!-- ====================================================================== -->
<xsl:template match="sl">
  <ul>
    <xsl:apply-templates/>
  </ul>
</xsl:template>


<xsl:template match="dt">
  <dt>
    <strong>
    <xsl:apply-templates />
    </strong>
  </dt>
</xsl:template>


<xsl:template match="dd">
  <dd>
    <xsl:apply-templates />
  </dd>
</xsl:template>


<!-- ====================================================================== -->
<!-- images section                                                         -->
<!-- ====================================================================== -->
<xsl:template match="figure|img|icon">
  <img src="{@src}" alt="{@alt}" hborder="3" vborder="3" border="1"/>
</xsl:template>


<!-- ====================================================================== -->
<!-- links section                                                          -->
<!-- ====================================================================== -->
<xsl:template match="link">
  <a href="{@href}"><xsl:apply-templates/></a>
</xsl:template>


<xsl:template match="connect">
  <xsl:apply-templates/>
</xsl:template>


<xsl:template match="jump">
  <a href="{@href}#{@anchor}" title="{@title}"><xsl:apply-templates/></a>
</xsl:template>


<xsl:template match="fork">
  <a href="{@href}" target="_blank"><xsl:apply-templates/></a>
</xsl:template>


<xsl:template match="anchor">
  <a name="{@id}"><xsl:apply-templates/></a>
</xsl:template>  


<!-- ====================================================================== -->
<!-- document informations and navigation                                   -->
<!-- ====================================================================== -->
<xsl:template name="totop">
  <div align="right">
    <a href="#top" title="to top">
      <img src="{$path2root}images/top9x10.gif" alt="top" border="0" />
    </a>  
  </div>
</xsl:template>


<xsl:template name="navline">
  <tr>
    <td align="center">
      <hr size="1" noshade="noshade" width="100%"/>
    </td>
  </tr>   
  <xsl:choose>    
  <xsl:when test="$docNav">
  <tr>
    <td align="left">
    <strong>Back to</strong>
      <xsl:for-each select="xalan:tokenize($docNav, ',')">
        <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
        <b><xsl:text disable-output-escaping='yes'>&amp;gt;</xsl:text></b> 
        <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
        <a href="{xalan:tokenize(., '[]')[2]}"> <xsl:value-of select="xalan:tokenize(., '[]')[1]"/></a>
      </xsl:for-each>
    </td>
  </tr>   
  </xsl:when>
  <xsl:otherwise>
  <tr>
    <td align="left">
      <strong>Back to: </strong><a href="{$path2root}index.html">Overview</a>
    </td>
  </tr>   
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>



<!-- ====================================================================== -->
<!--
     We have different doc info's depending on the type of documentation.
 Simple docs, or part of a book. This (using $type) might not be the best
 solution, but it's better than duplicating the code in book2html.xsl
     If you have any better idea, feel free to change it. 
                                                                            -->
<!-- ====================================================================== -->
<xsl:template name="docInfos">
  <xsl:param name="type"/>
  <xsl:choose>   
  <xsl:when test="$type='simple_doc'">
  <table border="0" width="100%" bgcolor="#ffffff" cellspacing="0" cellpadding="0">
    <tr>  
    <td align="left" valign="top">
      <table border="0" cellspacing="1" cellpadding="1">  

      <!-- Revision                                                    -->
      <xsl:if test="/*/header/revision">   
      <tr>
        <td align="right"><strong>Revision: </strong>
        </td>

        <!-- I have to do it this way because other-way the CVS tag for revision
             appears in the same line, and the CVS system feels the need to 
             replace it, with the actual revision which brakes the code 
         -->
        <xsl:variable name="revision">
          <xsl:value-of select="substring-after(//revision, '$Revision:')" />
        </xsl:variable>
        <td align="left">
          <xsl:value-of select="substring-before($revision, '$')" />
        </td>
              </tr>
    </xsl:if>

    <!-- Date                                                         -->
    <xsl:if test="/*/header/date">   
    <tr>
      <td align="right"><strong>Date: </strong>
      </td>
      <xsl:choose> 

      <xsl:when test="contains(//date, 'Date')">       
      <td align="left">
        <xsl:value-of select="substring-before(normalize-space(substring-after(//date, '$Date:')), ' ')" />
      </td>
      </xsl:when>

      <xsl:when test="//date">       
      <td align="left">
        <xsl:value-of select="//date" />
      </td>
      </xsl:when>

      <xsl:otherwise>
        <td></td>
      </xsl:otherwise>

      </xsl:choose>
    </tr>
  </xsl:if>
 </table> 
 </td>

 <td align="right" valign="top">
   <table border="0" cellspacing="1" cellpadding="1">  

   <!-- Location                                                     -->
   <xsl:if test="/*/header/location">   
     <tr>
       <td align="right"><strong>Latest Version: </strong>
       </td>
       <td align="left">
         <xsl:variable name="loc" select="//location/@href" />            
           <a href="{$loc}">
             <xsl:value-of select="$loc" />
             </a>
      </td>
    </tr>
  </xsl:if>

  <!-- Authors - Editors                                             -->
  <xsl:choose >
  <xsl:when test="count(/*/header/editor/person) = 1">   
  
  <tr>
    <td align="right"><strong>Editor: </strong></td>
    <td align="left">
      <xsl:value-of select="/*/header/editor/person/@name" />
        <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
        <a href="mailto:{/*/header/editor/person/@email}">
          <xsl:text disable-output-escaping='yes'>&amp;lt;</xsl:text>
          <xsl:value-of select="/*/header/editor/person/@email"/>
          <xsl:text disable-output-escaping='yes'>&amp;gt;</xsl:text>
        </a>        
      </td>
    </tr>
  </xsl:when>
  <xsl:otherwise>
    <tr>
      <td></td>
      <td></td>
    </tr>
  </xsl:otherwise>
  </xsl:choose>

  </table>
  </td>
  </tr>
  </table>
  </xsl:when>
  <xsl:otherwise> 
  <!-- 
       called from book2html.xsl to render the docInfo with $type holding the 
       chapter title.  
  -->
  <table border="0" width="100%"  cellspacing="0" cellpadding="0">
  <tr>
    <td width="75">
    </td>
    <td align="center" bgcolor="#ffffff">
  <table border="0" cellspacing="1" cellpadding="1">
    <tr>  
      <td align="center">
        <strong><xsl:value-of select="/book/header/title" /></strong>
      </td>
    </tr>
    <tr>  
      <td align="center">
        <em><xsl:value-of select="$type/@title" /></em>
      </td>
    </tr>
  </table>
  </td>
  <td align="right" width="75">
    <xsl:choose>
      <xsl:when test="$type/preceding-sibling::chapter[1]">
        <a href="{concat($type/preceding-sibling::chapter[1]/@file, '.html')}" title="{$type/preceding-sibling::chapter[1]/@title}">
          <img src="{$path2root}images/left.gif" alt="previous :" width="21" height="18" border="0"/>
        </a>          
      </xsl:when>
      <xsl:otherwise>
        <img src="{$path2root}images/left_d.gif" alt="      :" width="21" height="18" border="0"/>
      </xsl:otherwise>
    </xsl:choose>
    <a href="index.html" title="To Table of Contents"><img src="{$path2root}images/center.gif" alt=": contents :" width="28" height="24" border="0"/></a>
    <xsl:choose>
      <xsl:when test="$type/following-sibling::chapter[1]">
        <a href="{concat($type/following-sibling::chapter[1]/@file, '.html')}" title="{$type/following-sibling::chapter[1]/@title}">
          <img src="{$path2root}images/right.gif" alt=": next" width="21" height="18" border="0"/>
        </a>
      </xsl:when>
      <xsl:otherwise>
        <img src="{$path2root}images/right_d.gif" alt=":     " width="21" height="18" border="0"/>
      </xsl:otherwise>
    </xsl:choose>
  </td>
  </tr>
  </table>
  </xsl:otherwise>
  </xsl:choose>

</xsl:template>


<xsl:template name="toc">
  <xsl:param name="document" select="/document" />
    
  <xsl:if test="//s2">   
  <strong><a name="toc">Table of Contents</a></strong><br></br>
  <table border="0" cellspacing="0" cellpadding="0">
    <tr>  
    <td align="left" valign="top" class="toc">
      <xsl:for-each select="$document/descendant::s2|$document/descendant::s3|$document/descendant::s4">
        <xsl:if test="local-name(.)='s3'">   
        <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
        <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
        <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
        <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>

      </xsl:if>
      <xsl:if test="local-name(.)='s4'">   
      <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
      <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
      <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
      <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
      <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
      <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
      <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
      <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
    </xsl:if>
    <xsl:number 
      format="1.1.1." 
      level="multiple"
      count="s2|s3|s4" />
      <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
      <a href="#{generate-id(.)}"> <xsl:value-of select="@title" /></a><br/>
    </xsl:for-each>
    <br/>
    <br/>
    </td>
    </tr>
    </table>
    </xsl:if>
</xsl:template>


<xsl:template name="numbering">
  <xsl:number 
    format="1.1.1." 
    level="multiple"
    count="s2|s3|s4" />
    <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
</xsl:template>


<!-- Authors                                            -->
<xsl:template name="authors">  
<div align="right">
     <table border="0" cellspacing="1" cellpadding="1" width="40%">  

  <xsl:choose >
  <xsl:when test="count(/*/header/authors/person) > 1">   
    <tr>
      <td align="right"><strong>Authors: </strong></td>
      <td align="left"></td>
    </tr>

    <xsl:for-each select="/*/header/authors/person" >
      <tr>
        <td align="right"></td>
        <td align="left"><xsl:value-of select="@name" />
        <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
        <a href="mailto:{@email}">
          <xsl:text disable-output-escaping='yes'>&amp;lt;</xsl:text>
          <xsl:value-of select="@email"/>
          <xsl:text disable-output-escaping='yes'>&amp;gt;</xsl:text>
        </a></td>
      </tr>
    </xsl:for-each>
  </xsl:when>
  <xsl:when test="count(/*/header/authors/person) = 1">   
  
  <tr>
    <td align="right"><strong>Author: </strong></td>
    <td align="left">
      <xsl:value-of select="/*/header/authors/person/@name" />
        <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
        <a href="mailto:{/*/header/authors/person/@email}">
          <xsl:text disable-output-escaping='yes'>&amp;lt;</xsl:text>
          <xsl:value-of select="/*/header/authors/person/@email"/>
          <xsl:text disable-output-escaping='yes'>&amp;gt;</xsl:text>
        </a>        
      </td>
    </tr>
  </xsl:when>
  <xsl:otherwise>
    <tr>
      <td></td>
      <td></td>
    </tr>
  </xsl:otherwise>
  </xsl:choose>
  </table>
</div>
</xsl:template>

</xsl:stylesheet>