<?xml version="1.0"?>

<!-- ================================================================

$COPYRIGHT$

$Id: index_document2html.xsl,v 1.3 2001/08/13 11:21:39 neuro Exp $

Description:
This style file is responsible of the generation of the first page
(index.html). It uses the default templates defended in 
document2html.xsl which is imported, with a few exception where a 
different behavior was wanted and the templates where overridden.

Date        Author            Changes
Jun 26 2001 Remus Pereni      Created

================================================================= -->

<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">

<xsl:import 
  href="document2html.xsl" />

<xsl:param name="version" />
<xsl:param name="project" />


<!-- ====================================================================== -->
<!-- body section                                                           -->
<!-- ====================================================================== -->
<xsl:template match="body">
  <body>
    <a name="top"><xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text></a>

    <table width="95%" align="center">
      <tr>
        <td align="left"><a href="http://mappa.mundi.net/spacemapper/"><img src="images/sm.png" alt="SpaceMapper" border="0"/></a></td>
      </tr>
      <tr>
        <td align="center"><img src="images/{concat($project, '.png')}" alt="{$project}"/></td>
      </tr>
      <tr>
        <td align="center"><strong>Version: <xsl:value-of select="$version" /></strong></td>
      </tr>
      <tr>
        <td align="center"><xsl:call-template name="navline" /></td>
      </tr>
      <tr>
        <td id="content-panel">
          <xsl:apply-templates/>
        </td>
      </tr>
      <tr>
        <td align="center"><xsl:call-template name="footer"/></td>
      </tr>
    </table>

  </body>
</xsl:template>


<!-- ====================================================================== -->
<!-- body section                                                           -->
<!-- ====================================================================== -->
<xsl:template match="s3">
  <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
  <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
  <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
  <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
  <strong><xsl:value-of select="@title"/></strong>
  <div id="s3"><xsl:apply-templates/></div>
</xsl:template>


<!-- ====================================================================== -->
<!-- UL section                                                             -->
<!-- ====================================================================== -->
<xsl:template match="ul">
  <table width="80%" border="0" align="center" cellpadding="2">
    <xsl:apply-templates/>
  </table>  
</xsl:template>


<!-- ====================================================================== -->
<!-- LI section                                                             -->
<!-- ====================================================================== -->
<xsl:template match="li">
  <tr>
    <xsl:apply-templates/>    
  </tr>
</xsl:template>


<!-- ====================================================================== -->
<!-- link section                                                           -->
<!-- ====================================================================== -->
<xsl:template match="link">
  <xsl:choose> 

  <!-- if it starts with html is remote link, we put the right icon and
       make sure it opens in another window
   -->
  <xsl:when test="starts-with(@href, 'http')">
    <td align="left" width="80%">
      <img src="images/remote9x10.gif" hspace="3" alt="[Remote Link]"/> 
      <a href="{@href}" target="_new"><xsl:value-of select="@title"/></a>
    </td>   
    <td align="right" width="20%">  
      <i>website</i>
    </td>   
  </xsl:when>
  <xsl:otherwise>
    <td align="left" width="80%">
      <img src="images/local9x10.gif" hspace="3" alt="[Local Link]"/> 
      <a href="{@href}"><xsl:value-of select="@title"/></a>
    </td>   
    <td align="right" width="20%">  
      <i>local</i>
    </td>   
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>



<!-- ====================================================================== -->
<!-- NAVLINE section                                                        -->
<!-- ====================================================================== -->
<xsl:template name="navline">

  <xsl:for-each select="/document/body/*/s2" >
    <xsl:if test="position()!=1">
      <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
      <b>:</b> 
      <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
    </xsl:if>       
    <a href="#{generate-id(.) }"><xsl:value-of select="@title" /></a>
  </xsl:for-each>
</xsl:template>


<!-- The next section is not wanted, and have to be overriden in order
 to deactivate the default behaviour from document2html.xslt
-->
<xsl:template name="toc">
</xsl:template>

<xsl:template name="docInfos">
</xsl:template>

<xsl:template name="numbering">
</xsl:template>

<xsl:template name="authors">
</xsl:template>

</xsl:stylesheet>

