<?xml version="1.0"?>





<!-- ================================================================





$COPYRIGHT$





$Id: todo2document.xsl,v 1.4 2002/05/06 04:53:27 neuro Exp $





Date        Author            Changes


Jul 01 2001 Remus Pereni      Created





================================================================= -->





<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">

<xsl:import href="copyover.xsl"/>

<xsl:output method="xml" />






<!-- ====================================================================== -->


<!-- document section                                                       -->


<!-- ====================================================================== -->





<xsl:template match="todo">


  <document>


    <xsl:apply-templates/>


  </document>


</xsl:template>





<xsl:template match="body">


  <body>


    <s1 title="Datastore - Things To Do">


      <xsl:apply-templates/>


      <s2 title="Legend">


        <anchor id="legend"/>        


        <table>


          <tr>


            <td>


              <img src="images/green8x8.gif" alt="[Build]" /> 


                <xsl:text>  -  Build </xsl:text>


            </td>


            <td>


              <img src="images/red8x8.gif" alt="[Documentation]" /> 


                <xsl:text>  -  Documentation </xsl:text>


            </td>


            <td>


              <img src="images/blue8x8.gif" alt="[Code]" /> 


                <xsl:text>  -  Code </xsl:text>


            </td>


            <td>


              <img src="images/gray8x8.gif" alt="[Admin]:" /> 


                <xsl:text>  -  Admin </xsl:text>


            </td>


            <td>


              <img src="images/magenta8x8.gif" alt="[Design]:" /> 


                <xsl:text>  -  Design </xsl:text>


            </td>


          </tr>


        </table>


      </s2>


    </s1>


  </body>


</xsl:template>








<!-- ====================================================================== -->


<!-- release section                                                        -->


<!-- ====================================================================== -->





<xsl:template match="actions">


  <xsl:choose>





    <xsl:when test="@priority='showstopper'">


      <s2 title="Show Stopper">


        <xsl:apply-templates/>


      </s2>


    </xsl:when>





    <xsl:when test="@priority='high'">


      <s2 title="High Priority">


        <xsl:apply-templates/>


      </s2>


    </xsl:when>





    <xsl:when test="@priority='medium'">


      <s2 title="Medium Priority">


        <xsl:apply-templates/>


      </s2>


    </xsl:when>





    <xsl:when test="@priority='low'">


      <s2 title="Low Priority">


        <xsl:apply-templates/>


      </s2>


    </xsl:when>





    <xsl:when test="@priority='wish'">


      <s2 title="Wishes">


        <xsl:apply-templates/>


      </s2>


    </xsl:when>





    <xsl:when test="@priority='dream'">


      <s2 title="Dreams">


        <xsl:apply-templates/>


      </s2>


    </xsl:when>





  </xsl:choose>


</xsl:template>








<!-- ====================================================================== -->


<!-- Action section                                                         -->


<!-- ====================================================================== -->





<xsl:template match="action">


  <p align="left">


    <xsl:choose>





      <xsl:when test="@context='build'">


        <jump anchor="legend" title="Build">


          <img src="images/green8x8.gif" alt="[Build]" />


        </jump>


      </xsl:when>





      <xsl:when test="@context='docs'">


        <jump anchor="legend" title="Documentation">


          <img src="images/red8x8.gif" alt="[Documentation]" />


        </jump>


      </xsl:when>





      <xsl:when test="@context='code'">


        <jump anchor="legend" title="Code">


          <img src="images/blue8x8.gif" alt="[Code]" />


        </jump>


      </xsl:when>


      


      <xsl:when test="@context='admin'">


        <jump anchor="legend" title="Admin">


          <img src="images/gray8x8.gif" alt="[Admin]"/>


        </jump>


      </xsl:when>





      <xsl:when test="@context='design'">


        <jump anchor="legend" title="Design">


          <img src="images/magenta8x8.gif" alt="[Design]"/>


        </jump>


      </xsl:when>





    </xsl:choose>





    <xsl:value-of select="."/>





  <!-- Done by  -->


  <xsl:text> [</xsl:text>


  <link href="{concat('credits.html#', ./@assigned-to)}"><xsl:value-of select="./@assigned-to"/></link>


  <xsl:text>] </xsl:text>


 


  


</p>


</xsl:template>





</xsl:stylesheet>